/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun May 28 03:38:32 2006 by Jeff Dalton
 * Copyright: (c) 2003, 2004, 2005,2006,  AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.ip2.*;
import ix.iplan.IPlanOptionManager;
import ix.util.*;

/**
 * An I-P2 without a GUI.
 */
public class PlainIp2 extends Ip2 {

    public PlainIp2() {
	super();
	// This setting can be changed by a command-line argument.
	Parameters.setIsInteractive(false);
    }

    public PlainIp2(boolean setAgent) {
	super(setAgent);	// stand-alone or not
	// This setting can be changed by a command-line argument.
	Parameters.setIsInteractive(false);
    }

    public static void main(String[] argv) {

	Util.printGreeting("IP2 GUI-less Example");

	new PlainIp2().mainStartup(argv);

    }

    /**
     * Command-line argument processing.
     */
    protected void processCommandLineArguments() {
	super.processCommandLineArguments();
    }

    /**
     * Completes setup and initialization.
     */
    public void startup() {

	// Make the controller and model-manager
	modelManager = makeModelManager();
	controller = makeController();
	controller.connectTo(modelManager);

	// Make the option manager.
	// The model-manager and the controller's agendas
	// must exist before it can be connected.
	optionManager = new IPlanOptionManager(this);
	optionManager.connectYourself();

	// Add issue and activity handlers.
  	addHandlers();
	addHandlers(Parameters.getList("additional-handlers"));

	// Read any domain that should be present from the start,
	readDomain(getDomain());

	initOptions();

	// Load a plan if desired
	loadInitialPlan();

    }

}
