/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 18 16:39:06 2006 by Jeff Dalton
 * Copyright: (c) 2003, 2006, AIAI, University of Edinburgh
 */

package ix.test;

import java.awt.event.*;
import java.util.*;

import java.net.*;
import java.io.File;
import java.lang.reflect.Method;

public class MultiAgentTest {

    public MultiAgentTest() {
	super();
    }

    public static void main(String[] argv) throws Exception {
	System.out.println("Multi-Agent I-P2 Test");
	new Launcher().startAgent("ix.test.MultiAgentIp2", argv);
	new Launcher().startAgent("ix.test.MultiAgentIp2", argv);
    }

    public static class Launcher {

	ClassLoader loader;

	public Launcher() throws Exception {
	    loader = new URLClassLoader
		(new URL[] { new File("ix.jar").toURL() });
	}

	public void startAgent(String className, String[] argv)
               throws Exception {
	    Class c = loader.loadClass(className);
	    Class[] sig = new Class[] { argv.getClass() };
	    Method m = c.getMethod("main", sig);
	    m.invoke(null, new Object[] { argv });
	}

    }

}
