/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue May 27 18:07:54 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.awt.event.*;
import java.util.*;

import java.net.*;
import java.io.File;
import java.lang.reflect.Method;

import javax.swing.*;

import ix.icore.*;
import ix.ip2.*;
import ix.iface.util.ToolController;
import ix.util.*;
import ix.util.lisp.*;


public class MultiAgentIp2 extends Ip2 {

    static String[] initialArgv;

    public MultiAgentIp2() {
	super();
    }

    public void startup() {
	super.startup();
	addLaunchTool();
    }

    public static void main(String[] argv) {
	Util.printGreeting("Multi-Agent I-P2 Test");
	initialArgv = argv;
	new MultiAgentIp2().mainStartup(argv);
    }

    /**
     * Adds a simple tool.
     */
    protected void addLaunchTool() {
	addTool(new ToolController("Start Agent") {
	    public Object createTool() {
		return new LaunchTool();
	    }
	});
    }

    public class LaunchTool {
	public LaunchTool() {
	}
	public void setVisible(boolean v) {
	    final String name = JOptionPane.showInputDialog
		(frame, "Class name");
	    if (name != null) {
		new CatchingThread(new Runnable() {
		    public void run() {
			try {startAgent(name);}
			catch (Exception e) {
			    throw new RethrownException(e);
			}
		    }
		}).start();
	    }
	}
    }

    void startAgent(String className) throws Exception {
	Debug.noteln("Trying to start an instance of", className);
	// /\/: Not allowed to access test.MultiAgentTest$Launcher.
	Class c = Class.forName("ix.test.MultiAgentTest$Launcher");
	Object launcher = c.newInstance();
	String[] argv = initialArgv;
	Class[] sig = new Class[] {String.class, argv.getClass()};
	Method m = c.getMethod("startAgent", sig);
	m.invoke(launcher, new Object[] { className, argv });
    }

}

