/* File: QueueTest.java
 * Contains: Main program for testing a message queue
 * Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Created: January 1998
 * Updated: Wed Jan 15 15:44:01 2003 by Jeff Dalton
 * Copyright: (c) 1998, 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;
import ix.util.*;


/** A class for testing */

class MessageQueueTest {

    public static void main(String[] argv) {

	// Make a message queue
	MessageQueue q = new MessageQueue();

	// Put in some messages
	q.send("a");
	q.send("b");
	q.send("c");

	// Make and start a thread to receive messages
	Receiver target = new Receiver(q);
	target.start();

	// Loop reading messages from System.in and sending them.
	// A message "bye" leads to cleanup and exit.

	String input;

	System.out.println("Type \"bye\" to exit.\n");
	for (;;) {
	    // /\/: On some systems, at least, ask blocks other threads!
	    // input = ask("Message:");
	    input = Util.askLine("Message:");
	    if (input.equals("bye"))
		break;
	    q.send(input);
	    Thread.yield();
	}

	// Time for bed
	target.stop();			// DEPRECATED /\/
	System.out.println("Bye!\n");
	
    }


    static String ask(String prompt) {
	System.out.print(prompt + " ");
	System.out.flush();
	// Thread.yield();		// why? /\/
	return Util.readLine(System.in);
    }

}


class Receiver extends Thread {

    MessageQueue q;

    Receiver(MessageQueue q) {
	this.q = q;
    }

    public void run() {
	Object message;
	for (;;) {
	    message = q.nextMessage();
	    System.out.println("Received: " + message);
	    System.out.flush();
	}
    }

}

    
