/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jul  4 17:17:24 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.Variable;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

/**
 * Lets the user type things in a Lisp-like syntax and see the
 * corresponding XML.
 */
public class MatchChoiceTest {

    LispReader lin = new LispReader(System.in);
    VarMaker varMaker = new VarMaker();

    Symbol BYE = Symbol.intern("bye");

    MatchChoiceManager choiceManager = new MatchChoiceManager();

    public static void main(String[] argv) {
	new MatchChoiceTest().run();
    }

    void run() {
	for (;;) {
	    try { runTest(); }
	    catch (Throwable t) { Debug.noteException(t); }
	    finally { System.out.println(""); }
	}
    }

    void runTest() throws Exception {

	System.out.println("Enter a MatchChoice as alist of a-lists:");
	Object input = lin.readObject();
	if (input == BYE) {
	    System.exit(0);
	}
	else if (input instanceof LList) {
	    MatchChoice choice = makeMatchChoice((LList)input);
	    choiceManager.add(choice);
	    choiceManager.recalculate();
	    choiceManager.showState();
	    Map possible = choiceManager.getPossibleValues();
	    System.out.println("Values " + possible);
	}
	else {
	    System.out.println("Invalid input");
	}

    }

    MatchChoice makeMatchChoice(LList alists) {
	List branches = new LinkedList();
	for (Iterator i = alists.iterator(); i.hasNext();) {
	    LList a = (LList)varMaker.copy(i.next());
	    Map m = a.alistToMap(new TreeMap());
	    Bindings b = new Bindings(m);
	    branches.add(b);
	}
	return new MatchChoice(branches);
    }

    static class VarMaker extends ObjectCopier{
	Map toVarMap = new HashMap();
	public Object mapElement(Object obj) {
	    return obj instanceof ItemVar
		? mapItemVar((ItemVar)obj)
		: copy(obj);
	}
	Variable mapItemVar(ItemVar name) {
	    Variable v = (Variable)toVarMap.get(name);
	    if (v == null) {
		v = new Variable(name);
		toVarMap.put(name, v);
	    }
	    return v;
	}
    }

}

/* Some test input

( ((?a 1) (?b 2)) 
  ((?a 2) (?b 1)) )

( ((?a 1) (?b 2)) )

( ((?a 1)) )

( ((?b 3)) )

*/
