/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jul  4 14:51:20 2003 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * Lets the user type things in a Lisp-like syntax and see the
 * corresponding XML.
 */
public class LispToXMLTest {

    public static void main(String[] argv) {

	XMLTranslator xmlt = new XMLTranslator();

	LispReader reader = new LispReader(System.in);

	Symbol BYE = Symbol.intern("bye");

	for (;;) {
	    System.out.print("Lisp: ");
	    try {
		Object in = reader.readObject();
		if (in == BYE)
		    return;
		Object obj = in;
	        System.out.println(Lisp.printToString(obj));
		String xml = xmlt.objectToXMLString(obj);
		System.out.print(xml);
		Object back = XML.objectFromXML(xml);
		System.out.println(Lisp.printToString(back));
	    }
	    catch (Throwable t) {
		Debug.noteException(t);
	    }
	}

    }

}


