/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Aug 23 05:43:03 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.iscript.Expression;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * Lets the user type Lisp code and have it printed as IScript XML.
 */
public class LispToIScriptXMLTest {

    public static void main(String[] argv) {

	LispReader reader = new LispProgramReader(System.in);
	LispInterpreter li = new LispInterpreter();

	Symbol BYE = Symbol.intern("bye");

	for (;;) {
	    System.out.print("Lisp: ");
	    try {
		Object in = reader.readObject();
		if (in == BYE)
		    return;
		Expression expr = li.parseForm(in).externalForm();
		System.out.println(XML.objectToXMLString(expr));
	    }
	    catch (Throwable t) {
		Debug.noteException(t);
	    }
	}

    }

}


