/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Dec  2 17:49:12 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.IXAgentExtension;

import ix.ip2.*;

import ix.iface.util.ToolController;

import ix.util.*;
import ix.util.xml.XMLTreeEditFrame;

public class ExtensionExample implements IXAgentExtension {

    Ip2 ip2;

    public ExtensionExample(Ip2 ip2) {
	this.ip2 = ip2;
    }

    public void installExtension() {
	ip2.addTool(new ToolController("Example Tree Editor") {
	    public Object createTool() {
		return new XMLTreeEditFrame(ip2);
	    }
	});
    }

}
