/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Nov  3 20:29:49 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.test;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.math.BigInteger;
import java.util.*;

import ix.util.*;
import ix.util.lisp.*;		// for test main
import ix.util.xml.XML;		// for now /\/

public class DigestSet {

    protected MessageDigest md = makeMessageDigest();
    protected Set digested = new HashSet();
    protected Map digestObjectCache = new WeakHashMap();

    public DigestSet() {
    }

    public class IsNewPredciate implements Predicate1 {
	public boolean trueOf(Object a) {
	    return add(a);
	}
    }

    public boolean add(Object obj) {
	return digested.add(memoizedDigestObject(obj));
    }

    public boolean contains(Object obj) {
	return digested.contains(memoizedDigestObject(obj));
    }

    public BigInteger digestObject(Object obj) {
	md.reset();
	md.update(XML.objectToXMLString(obj).getBytes()); // for now /\/
	// Debug.noteln("String", XML.objectToXMLString(obj));
	return new BigInteger(1, md.digest());
    }

    public BigInteger memoizedDigestObject(Object obj) {
	BigInteger result = (BigInteger)digestObjectCache.get(obj);
	if (result == null) {
	    result = digestObject(obj);
	    digestObjectCache.put(obj, result);
	}
	Debug.noteln("Digested " + obj + " = " + result);
	return result;
    }

    private static MessageDigest makeMessageDigest() {
	try {
	    return MessageDigest.getInstance("MD5");
	}
	catch (NoSuchAlgorithmException e) {
	    throw new RethrownException(e);
	}
    }

    public static void main(String[] argv) {
	DigestSet set = new DigestSet();
	LispReader reader = new LispReader(System.in);
	Symbol BYE = Symbol.intern("bye");
	for (;;) {
	    System.out.print("Lisp: ");
	    try {
		Object in = reader.readObject();
		if (in == BYE)
		    return;
	        System.out.println(Lisp.printToString(in));
		// System.out.println(XML.objectToXMLString(in));
		System.out.println(set.digestObject(in));
		System.out.println(set.memoizedDigestObject(in));
		System.out.println("Seen before = " + !set.add(in));
	    }
	    catch (Throwable t) {
		Debug.noteException(t);
	    }
	}

    }

}
