/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jul 10 13:35:39 2003 by Jeff Dalton
 * Copyright: (c) 2001, 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.*;
import ix.ip2.*;
import ix.util.*;
import ix.util.lisp.*;

/**
 * Adds a handler action that changes the agent's symbol-name.
 */
public class ChangeSymbolNameHandler extends ActivityHandler {

    private Symbol S_CHANGE_SYMBOL_NAME = Symbol.intern("change-symbol-name");

    protected Ip2 ip2;

    public ChangeSymbolNameHandler(Ip2 ip2) {
	super("Change this agent's symbol name");
	this.ip2 = ip2;
    }

    public List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((change-symbol-name ?new-name))");
    }

    public boolean appliesTo(AgendaItem item) {
	LList pattern = item.getPattern();
	return pattern.length() == 2
	    && pattern.get(0) == S_CHANGE_SYMBOL_NAME;
    }

    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }

    public void handle(AgendaItem item) {
	// (change-symbol-name ?name)
	LList pattern = (LList)Variable.removeVars(item.getPattern());
	String name = pattern.get(1).toString();
	ip2.setAgentSymbolName(name);
	item.setStatus(Status.COMPLETE);
    }

}
