/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Original Postix: Stephen Potter <stephenp@inf.ed.ac.uk>
 * Updated: Mon Aug 28 16:11:36 2006 by Jeff Dalton
 * Copyright: (c) 2001 - 2005 AIAI, University of Edinburgh
 */

package ix.postix;

import javax.swing.*;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Dimension;
import java.awt.event.*;
import java.io.File;
import java.util.*;

import ix.postix.*;

import ix.ichat.ChatFrame;
import ix.ispace.ISpaceTool;

import ix.icore.*;
import ix.iview.*;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.util.ToolController;
import ix.iface.util.LogoPanel;
import ix.iface.util.IconImage;
import ix.iface.util.IFUtil;
import ix.ip2.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * The main frame of the Postix user interface.
 */
public class PostixFrame extends Ip2Frame implements ActionListener {

    final JTextField active = new JTextField(15);

    Postix postix;

    public PostixFrame(Postix postix) {
	super(postix);		// assigns to ip2 field
	this.postix = postix;
    }

    public void setUp() {
	setIconImage(IconImage.getIconImage(this));
	activityViewer = postix.getActivityViewer();

	contentPane = getContentPane();

	// setSize(300, 150);	// preliminary
	setSize(540, 240);
	setJMenuBar(makeMenuBar());
	// Layout manager defaults to BorderLayout.

	// Simplify the activity viewer
	if (activityViewer instanceof ActivityTableViewer) {
	    ActivityTableViewer av = (ActivityTableViewer)activityViewer;
	    av.removeColumn(av.findColumn("Annotations"));
	    av.findColumn("Description")
		.setHeaderValue("Item");
	}

	// Package activity viewer
	ThingEditorPanel activityPanel = 
	  new ThingEditorPanel(null, true, "ToDo", 
			       (JComponent)activityViewer);


	JScrollPane todo = new JScrollPane(activityPanel);
	todo.setPreferredSize(new Dimension(120,100));

	JPanel acting = new JPanel(new GridLayout(1,2));
	JPanel buttons = new JPanel(new GridLayout(1,2));

	acting.add(active);
	JButton addB = new JButton("Add");
	this.getRootPane().setDefaultButton(addB);
	JButton clearB = new JButton("Clear");
	buttons.add(addB);
	buttons.add(clearB);
	acting.add(buttons);

	addB.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		Debug.noteln("I-P2 action:", command);
		Debug.expect(command.equals("Add"));
		String actext = (active.getText()).trim();
		if(!actext.equals("")){
		    LList pattern = PatternParser.parse(actext);
		    activityViewer.addItem
			(activityViewer.makeItem(pattern));
		    active.setText("");
		}
	    }
	});

	clearB.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		Debug.noteln("I-P2 action:", command);
		Debug.expect(command.equals("Clear"));
		active.setText("");
	    }
	});

	contentPane.add(acting, BorderLayout.NORTH);

	contentPane.add(todo);

	// Add something that identifies the system etc.
	logoPanel = postix.makeLogoPanel();
	contentPane.add(logoPanel, BorderLayout.SOUTH);

    }

    protected void becomeVisible() { // sep method so can do it last
	// It is expected that this is called only once.

	if (Parameters.haveParameter("frame-size")) {
	    Dimension size = Parameters.getDimension("frame-size");
	    pack();		// needed for divider adjust /\/
	    setSize(size);
	}
	else {
	    // setReasonableSize();
	}

	// Seem to need this here, rather than, say, later.
	// super.validate();

	// Make it visible
	setVisible(true);

    }

    protected JMenuBar makeMenuBar() {
	JMenuBar result = super.makeMenuBar();
	result.remove(IFUtil.getMenuBarMenu(result, "New", true));
	return result;
    }


    protected void addIp2Tools() {
	addTool(new ToolController("Domain Editor") {
	    public Object createTool() {
		return makeDomainEditor(ip2, ip2.getDomain());
	    }
	});
	addTool(new ToolController("I-Space") {
	    public Object createTool() {
		return new ISpaceTool(ip2);
	    }
	});
	// No I-Plan tool
	addTool(new ToolController("Messenger") {
	    public Object createTool() {
		return new ChatFrame
		    (ip2, ip2.getAgentDisplayName() + " Messenger");
	    }
	});
	addTool(new ToolController("HTML Viewer") {
	    public Object createTool() {
		return makeHTMLViewer();
	    }
	});
    }

}
