/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Original Postix: Stephen Potter <stephenp@inf.ed.ac.uk>
 * Updated: Fri Jan 21 17:27:26 2005 by Jeff Dalton
 * Copyright: (c) 2001 - 2005, AIAI, University of Edinburgh
 */

package ix.postix;

import javax.swing.*;
import java.util.*;

import ix.ip2.event.AgendaListener;
import ix.ip2.*;
import ix.util.*;

/** 
 * A minimized I-P2 class and application main program.
 */
public class Postix extends Ip2 {

    public Postix() {
	this(true);
    }

    public Postix(boolean setAgent) {
	super(setAgent);

	// Change some defaults
	displayName = "PostI-X Panel";
	logoLine1 = "PostI-X";
	logoLine2 = "New!";
	logoImage = "ip2-logo.gif";
    }

    /**
     * Main program.
     */
    public static void main(String[] argv) {

	Util.printGreeting("Postix");

	new Postix().mainStartup(argv);

    }

    /**
     * Completes basic setup and initialization.
     */
    public void startup() {

	// Make controller and model-manager
	modelManager = makeModelManager();
	controller = makeController();
	controller.connectTo(modelManager);

	// Create the frame without filling in anything interesting.
	// This allows the viewers to add tools, for example.
	frame = new PostixFrame(this);

	// Viewers
	activityViewer = makeActivityViewer();

	// Connect the viewers
	controller.addActivityListener((AgendaListener)activityViewer);

  	addHandlers();

	readDomain(getDomain());

	// Complete the frame
	((PostixFrame)frame).setUp();
	Util.swingAndWait(new Runnable() {
	    public void run() {
		// /\/: We do some adjustment after making the
		// frame visible, so we switch threads here.
		completeStartup();
	    }
	});

    }

    protected void completeStartup() {
	((PostixFrame)frame).becomeVisible();
	// No options.
	// initOptions();
	loadInitialPlan();
    }

    AgendaViewer getActivityViewer() {
	// /\/: This method is necessary because the activityViewer
	// field is "protected" in Ip2, and PostixFrame needs to
	// get the viewer.
	return activityViewer;
    }

    public void handleInput(IPC.InputMessage message) {
	// /\/: Avoid option-related special cases.
	handleInputDirectly(message);
    }

}
