/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 25 22:23:58 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2006, AIAI, University of Edinburgh
 */

package ix.itest;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.*;

import ix.ichat.ChatMessage;
import ix.iface.util.Reporting;
import ix.iface.util.TranscriptTextPane;

import ix.ispace.ContactManager;

import ix.icore.IXAgent;
import ix.icore.Sendable;
import ix.icore.Annotated;

import ix.util.*;
import ix.util.lisp.Symbol;

/**
 * Panel for displaying received messages.
 */
public class ReceivePanel extends JPanel {

    private static Symbol MESSAGE_COLOR = Symbol.intern("message-color");

    IXAgent agent;
    ContactManager contactManager;

    TranscriptTextPane transcript = new TranscriptTextPane();

    public ReceivePanel(IXAgent agent) {
	this.agent = agent;
	this.contactManager = agent.getContactManager();

	setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	setBorder(BorderFactory.createTitledBorder("Transcript"));
	// A Dimension is width, height.  We want to make
	// sure there's a reasonable height.
	transcript.setPreferredSize(new Dimension(400, 150));
	add(new JScrollPane(transcript));
    }

    /**
     * Handles external input in the form of an IPC.InputMessage
     * that contains an Issue or Report object.
     */
    public void handleInput(IPC.InputMessage message) {
	transcript.appendLine(senderColor(message.getContents()),
			      Reporting.messageDescription(message));
    }

    public void newMessage(ChatMessage message) {
	Color color = senderColor(message);
	transcript.appendLine(color, message.getSenderId()
			      + " at " + Reporting.dateString()
			      + ":");
	transcript.appendIndentedLines(3, color, message.getText());
    }

    protected Color senderColor(Object contents) {
	final Color defaultColor = Color.black;
	Color messageColor = null;
	String senderId = null;
	if (contents instanceof Annotated) {
	    messageColor = (Color)((Annotated)contents)
		.getAnnotation(MESSAGE_COLOR);
	}
	if (contents instanceof Sendable) {
	    senderId = ((Sendable)contents).getSenderId().toString();
	}
	if (messageColor != null) {
	    if (senderId != null) {
		contactManager.setAgentColor(senderId, messageColor);
	    }
	    return messageColor;
	}
	else if (senderId != null) {
	    messageColor = contactManager.getAgentColor(senderId);
	}
	return messageColor != null ? messageColor : defaultColor;
    }

}
