/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Mar 15 23:28:21 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2006, AIAI, University of Edinburgh
 */

package ix.ispace;

import java.util.*;

import ix.util.*;
import ix.util.lisp.LList;

/**
 * A capability that corresponds to a verb such as would appear
 * in an issue or activity pattern.
 */
public class VerbCapability extends Capability {

    protected String verb;		// Symbol? /\/

    public VerbCapability() {
    }

    public VerbCapability(String verb) {
	this.verb = verb;
    }

    /**
     * Returns the capability that corresponds to a string containing
     * a verb.
     */
    public static VerbCapability from(String verb) {
	return new VerbCapability(verb);
    }

    /**
     * Returns the capability that corresponds to the pattern's
     * verb.  Patterns are assumed to have a verb as their first
     * element.
     */
    public static VerbCapability from(LList pattern) {
	return new VerbCapability(pattern.car().toString());
    }

    /**
     * Returns the verb.
     */
    public String getVerb() {
	return verb;
    }

    public void setVerb(String v) {
	this.verb = v;
    }

    /**
     * Returns true iff the required capability is a VerbCapability
     * for the same verb.
     */
    public boolean subsumes(Capability required) {
	return required instanceof VerbCapability
	    && ((VerbCapability)required).verb.equals(verb);
    }

    public boolean equals(Object obj) {
	return obj instanceof VerbCapability
	    && ((VerbCapability)obj).verb.equals(verb);
    }

    public String toString() {
	return "VerbCapability[" + verb + "]";
    }

}

// Issues:
// * Canonicalize?
