/* Author: Gerhard Wickler <g.wickler@ed.ac.uk>
 * Updated: Wed Jun 21 17:23:05 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.isim.actions;

import java.util.Iterator;

import ix.isim.*;
import ix.util.lisp.Symbol;
import ix.util.IPC;
import ix.util.Name;
import ix.icore.*;
import ix.icore.domain.Constraint;
import ix.util.lisp.LList;
import ix.icore.Sendable;
import ix.ichat.ChatMessage;
import ix.util.match.MatchEnv;

public class SendMessage extends ExecutableAction {

    final static Symbol sendMessageSy = Symbol.intern("send-message");
    final static Symbol issueSy = Symbol.intern("issue");
    final static Symbol activitySy = Symbol.intern("activity");
    final static Symbol constraintSy = Symbol.intern("constraint");
    final static Symbol messageSy = Symbol.intern("message");
    final static Symbol reportSy = Symbol.intern("report");

    public SendMessage() {
        super();
    }

    public void executeAction(MatchEnv env) throws SimulationException {
        // make sure the activity has the correct verb:
        if (! action.getActivity().getVerb().equals(sendMessageSy)) {
            throw new SimulationException(
                    "Activity verb must be " + sendMessageSy +
                    ", not " + action.getActivity().getVerb());
        }
        // send the message:
        Iterator elti=action.getActivity().getParameters().iterator();
        Symbol msgType = (Symbol)elti.next();
        Name sender = Name.valueOf(elti.next());
        String recipient = elti.next().toString();
        // message syntax depends on message type!
        Sendable message = null;
        if (msgType.equals(issueSy)) {
            message = new Issue((LList)elti.next());
        } else if (msgType.equals(activitySy)) {
            message = new Activity((LList)elti.next());
        } else if (msgType.equals(constraintSy)) {
            message = new Constraint(
                      (Symbol)elti.next(),
                      (Symbol)elti.next(),
                      (LList)elti.next());
        } else if (msgType.equals(messageSy)) {
            message = new ChatMessage(
                    elti.next().toString(), sender.toString());
        } else if (msgType.equals(reportSy)) {
            message = new Report(
                  ReportType.valueOf(elti.next().toString()),
                  elti.next().toString());
        }
        message.setSenderId(sender);
        // the actual send ing of the message:
        try {
            IPC.getCommunicationStrategy().sendObject(recipient, message);
        } catch (Exception e) {
            throw new SimulationException("Unable to send message.");
        }
    }
}
