/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr  7 22:49:58 2005 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.ip2.*;
import ix.icore.*;
import ix.icore.process.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

/**
 * A way to achieve a condition.
 */
class SlipAchiever {

    PatternAssignment cond;
    Refinement refinement;
    PatternAssignment effect;
    MatchEnv condMatchEnv;

    SlipAchiever(PatternAssignment cond,
		 Refinement refinement,
		 PatternAssignment effect,
		 MatchEnv condMatchEnv) {
	this.cond = cond;
	this.refinement = refinement;
	this.effect = effect;
	this.condMatchEnv = condMatchEnv;
	Debug.noteln("Making achiever for " + cond +
		     " using " + refinement + " " + effect +
		     " with env " + condMatchEnv);
    }

    MatchEnv rematchCond() {
	// Some Variables may have been bound since we originally
	// did the matching.
	MatchEnv pEnv = Matcher.match(cond.getPattern(), effect.getPattern());
	if (pEnv == null)
	    return null;
	else
	    return Matcher.match(cond.getValue(), effect.getValue(), pEnv);
    }

    public String toString() {
	return "SlipAchiever[using " + refinement + " for cond " + cond + "]";
    }

}
