/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Oct 24 22:57:53 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iplan;

import ix.ip2.Ip2;

/**
 * Produces a description of some aspect of a plan.  The description is
 * returned by the {@link #evaluatePlan(Ip2, String)} method as a
 * {@link PlanEvaluation}.  The plan-evaluator also has a description,
 * returned by its {@link #getShortDescription()} method, that
 * describes that plan-aspect.  For example, a plan-evaluator
 * that counted the number of activities in a plan might have
 * "number activities in plan" as it's description and return
 * the number as an Integer wrapped in a PlanEvaluation.
 */
public abstract class PlanEvaluator {

    protected String shortDescription = "not a description";
    private boolean visible = true;

    public PlanEvaluator() {
    }

    public PlanEvaluator(String shortDescription) {
	this.shortDescription = shortDescription;
    }

    public String getShortDescription() {
	return shortDescription;
    }

    public abstract PlanEvaluation evaluatePlan(Ip2 ip2, String optionName);

    public boolean isVisible() {
	return visible;
    }

    public void setVisible(boolean v) {
	visible = v;
    }

}
