/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Oct 24 22:51:53 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iplan;

/**
 * A description of some aspect of a plan.  A PlanEvaluation is typically
 * produced by a {@link PlanEvaluator}.
 */
public interface PlanEvaluation {

    /**
     * Returns the current value of this evaluation.  Note that the
     * value may change after the user requests more information.
     *
     * @see #detailsRequested()
     */
    public Object getValue();

    /**
     * Indicates whether or not more information is available if the
     * used requests it.
     *
     * @see #detailsRequested()
     */
    public boolean hasDetails();

    /**
     * Tells the evaluation that the user has requested more information.
     * For some evaluations, the work will not be done until this method
     * is called.  Until then, the value returned by {@link #getValue()}
     * will just be a place-holder that indicates that more information
     * is available.  This method will then typically change that value
     * to show the real result of the evalutaion.
     *
     * <p>It is recommended that any evaluations that require a
     * substantial amount of computation be handled in that delayed,
     * "when requested" fashion.</p>
     *
     * @see #hasDetails()
     */
    public void detailsRequested();

}
