/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Oct 24 04:30:15 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.ip2.Ip2;

import ix.util.*;

public class PlanEvalManager {

    protected List planEvaluators = new LinkedList();

    public PlanEvalManager() {
	addPlanEvaluators();
    }

    public void addPlanEvaluator(PlanEvaluator e) {
	planEvaluators.add(e);
    }

    public List getPlanEvaluators() {
	return planEvaluators;
    }

    public Map evaluatePlan(Ip2 ip2, String optionName) {
	Debug.noteln("Evaluating plan in agent", ip2);
	Debug.noteln("Evaluating plan in option", optionName);
	Map result = new StableHashMap();
	for (Iterator i = planEvaluators.iterator(); i.hasNext();) {
	    PlanEvaluator e = (PlanEvaluator)i.next();
	    result.put(e, evalSafely(e, ip2, optionName));
	}
	return result;
    }

    public PlanEvaluation evalSafely(PlanEvaluator e, Ip2 ip2,
				     String optionName) {
	try {
	    return e.evaluatePlan(ip2, optionName);
	}
	catch (Throwable t) {
	    Debug.noteException(t);
	    return new ErrorPlanEvaluation(t);
	}
    }

    public void addPlanEvaluators() {
    }

}

// Issues:
// * PlanEvalManager because PlanEvaluationManager suggests that it
//   manages evaluations, rather than evaluators, and because
//   PlanEvaluatorManager is so awkward.
