/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar 31 20:10:14 2005 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.ip2.*;
import ix.icore.*;
import ix.icore.process.*;
import ix.icore.plan.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

public class IPlanModelManager extends Ip2ModelManager {

    IPlanWorldStateManager worldCM;

    public IPlanModelManager(Ip2 ip2) {
	super(ip2);
    }

    protected Ip2WorldStateManager makeWorldStateManager() {
	return worldCM = new IPlanWorldStateManager(this);
    }

    protected void postProcessInstalledPlan(PlanInstaller pi) {
	// No nothing.  But override the inherited method,
	// because it does some things we don't want.
    }

    void satisfyConds(PNode at, ListOfConstraint conds, MatchEnv env) {
	worldCM.satisfyConds(at, conds, env);
    }

    // /\/ It's protected in Ip2ModelManager
    public void  handleEffects(PNode node, List effects) {
	super.handleEffects(node, effects);
    }

    public void setWorldStateMap(Map desiredState) { // for Slip /\/
	Debug.noteln("Setting world state to", desiredState);
	Map now = getWorldStateMap();
	// First delete any patterns that are not in the desired state.
	for (Iterator i = now.entrySet().iterator(); i.hasNext();) {
	    Map.Entry e = (Map.Entry)i.next();
	    LList pat = (LList)e.getKey();
	    if (desiredState.get(pat) == null)
		deleteEffect(new PatternAssignment(e));
	}
	// Add any new patterns needed, and give any remaining
	// old patterns their desired values.
	handleEffects(PatternAssignment.mapToAssignments(desiredState));
    }

    public void applyEnv(MatchEnv env) {
	Map bindings = null; 	// create if needed
	for (Iterator i = env.entrySet().iterator(); i.hasNext();) {
	    Map.Entry e = (Map.Entry)i.next();
	    Object var = e.getKey();
	    if (var instanceof Variable) {
		if (bindings == null)
		    bindings = new HashMap();
		bindings.put(var, e.getValue());
	    }
	}
	if (bindings != null)
	    bindVariables(bindings);
    }

}
