/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 29 12:52:29 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2004, 2006, AIAI, University of Edinburgh
 */

package ix.iplan;

import ix.ip2.*;

/**
 * Generates HandlerActions for an AgendItem.
 */
public class IPlanCompletionHandler extends CompletionHandler {

    public IPlanCompletionHandler(IPlan iplan) {
	super(iplan);
    }

    public void addHandlerActions(AgendaItem item) {
	// Standard options that all items have.
	item.addAction(new NoAction(item));
	item.addAction(new DoneAction(item));
	item.addAction(new NotApplicableAction(item));
    }

}
