/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Apr  4 16:56:48 2005 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.io.*;		// for reading initial options
import java.util.*;

import ix.icore.domain.Domain;
import ix.icore.process.ProcessModelManager;
import ix.icore.plan.Plan;	// /\/
import ix.icore.Activity;	// /\/
import ix.ip2.*;
import ix.util.*;
import ix.util.lisp.*;		// /\/
import ix.util.xml.*;

/**
 * An interactive planner.
 */

public class IPlan extends Ip2 {

    public IPlan() {
	this(true);
    }

    protected IPlan(boolean setAgent) {
	super(setAgent);
	agentTypeName = "I-X Planner";
	logoLine1 = "I-X Planner";
	displayName = agentTypeName;
	showOptions = true;	// default value
	Parameters.setParameter("plan-state-to-save", "*"); //\/
	Parameters.getParameter("plan-state-to-save"); // mark as used /\/
    }

    public static void main(String[] argv) {
	Util.printGreeting("I-Plan");
	new IPlan().mainStartup(argv);
    }

    public void setDomain(Domain dom) {
	dom.checkConsistency();
	this.domain = dom;
    }

    public static Planner makeDefaultPlanner() {
	Slip slip = new Slip(false);
	slip.mainStartup(new String[]{});
	return slip;
    }

    protected ProcessModelManager makeModelManager() {
	return new IPlanModelManager(this);
    }

    protected Ip2Frame makeIp2Frame() {
	return new IPlanFrame(this);
    }

    protected void initOptions() {
	optionManager.initOptions();
    }

    /**
     * Install any built-in issue and activity handlers.
     */ 
    protected void addHandlers() {

	// Handler that lets the user do nothing or make items complete.
	controller
	    .addItemHandler(new IPlanCompletionHandler(this));

	// Expansion
	controller
	    .addActivityHandler(new IPlanExpandHandler(this));

	// Condition satisfaction
	// controller
	//     .addActivityHandler(new IPlanConditionHandler(this));

    }

}

// Issues:
// * Instead of e.g. IPlanExpandHandler, names based on the algorithm,
//   because IPlan ought to be able to work with > 1 algorithm.
