/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed May 31 02:02:52 2006 by Jeff Dalton
 * Copyright: (c) 2005, 2006, AIAI, University of Edinburgh
 */

package ix.iplan;

import ix.icore.domain.Domain;
import ix.icore.plan.Plan;

import ix.ip2.*;

import ix.util.*;

/**
 * A plan-evaluation that runs the plan-checking simulator.
 * It's also an illustration of an evaluation that's just a
 * place-holder until the user requests that the actual evaluation
 * be produced.  The value is initially "run".  The simulator
 * isn't run until the user requests the details.  Then the
 * simulator's output is displayed in a new window, and the
 * value becomes either "ok" or "n problems", where n is the
 * number of problems found by the simulator.  If the details
 * are requested again, the simulator's output (which was saved)
 * is displayed again.
 */
public class ChecksimPlanEvaluation implements PlanEvaluation {

    Ip2 ip2;
    IPlanOptionManager.Opt option;
    String nextStep = "run";

    String simOutput = "";

    public ChecksimPlanEvaluation(Ip2 ip2, String optionName) {
	this.ip2 = ip2;
	this.option =  ip2.getOptionManager().getOption(optionName);
    }

    public Object getValue() {
	return nextStep;
    }

    public boolean hasDetails() {
	return true;
    }

    public void detailsRequested() {
	IPlanTool iptool = (IPlanTool)ip2.ensureTool("I-Plan");
	if (nextStep.equals("run")) {
	    Plan p = option.asPlan();
	    Domain d = ip2.getDomain();
	    PlanCheckingSimulator sim = new PlanCheckingSimulator(p, d);
	    iptool.checkPlan(sim);
	    simOutput = iptool.getSimFrame().getText();
	    if (sim.getProblems().isEmpty())
		nextStep = "ok";
	    else
		nextStep = sim.getProblems().size() + " problems";
	}
	else if (nextStep.equals("ok") || nextStep.endsWith("problems")) {
	    TextAreaFrame sf = iptool.getSimFrame();
	    sf.setText("The simulation output was:\n\n" + simOutput);
	    sf.setVisible(true);
	}
	else {
	    throw new ConsistencyException
		("Unknown next-step", nextStep);
	}
    }

}
