/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr 29 01:18:24 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.util.*;
import ix.util.context.*;

/**
 * Alternative -- a backtrack point.
 */
public abstract class Alternative implements Runnable {

    protected Context context;
    protected double cost = 0;

    public Alternative() {
	this.context = Context.getContext();
    }

    public Context getContext() {
	return context;
    }

    public double getCost() {
	return cost;
    }

    public void setCost(Slip slip) {
	// Called when the alt is posted.
	//\/ The parameter should allow any planning algorithm, not only Slip.
	this.cost = calcCost(slip);
    }

    protected double calcCost(Slip slip) {
	// return 0;
	return slip.MM().getNodes().size();
    }

    public String toString() {
	return this.getClass().getName() + "[" +
	    "in " + context +
	    " cost " + cost +
	    "]";
    }

}
