/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Apr 15 00:52:00 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.ip2.event;

import java.util.EventListener;
import java.util.Map;

import ix.ip2.AgendaManager;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;

public interface AgendaListener extends EventListener {

    // /\/: setAgendaManager is called by the PanelController,
    // which is probably wrong.  
    public void setAgendaManager(AgendaManager am);

    public void itemAdded(AgendaEvent e, AgendaItem i);

    public void itemRemoved(AgendaEvent e, AgendaItem i);

    public void itemHandled(AgendaEvent e,
			    AgendaItem i,
			    HandlerAction a);

    public void newBindings(AgendaEvent e,
			    Map bindings);

}

// Issues:
// * It looks like the JDK way is to put all the information in the
//   event object rather than pass additional parameters.
