/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 25 20:30:09 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2003, 2005, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.util.*;

/**
 * Generates a {@link HandlerAction} that removes an issue and sets
 * up the Messenger to add it as an activity.  This allows the issue
 * to be edited before it becomes an activity.  Compare
 * {@link PerformAsActivityHandler}.
 */
public class TransformToActivityHandler extends IssueHandler {

    Ip2 ip2;

    public TransformToActivityHandler(Ip2 ip2) {
	super("Transform to activity");
	this.ip2 = ip2;
    }

    public void handle(AgendaItem item) {
	Issue issue = (Issue)item.getAbout();
	ip2.getController().getIssueAgenda().removeItem(item);
	ip2.frame.getSendPanelVisible().transformToActivity(issue);
    }

    /* --- old version ---
    public void handle(AgendaItem item) {
	Issue issue = (Issue)item.getAbout();
	Activity activity = new Activity(issue.getPattern());
	// Take across some other fields ...
	activity.setSenderId(issue.getSenderId());
	activity.setPriority(issue.getPriority());
	activity.setReportBack(issue.getReportBack());
	activity.setRef(issue.getRef());
	// ... Any others ...?  /\/
	// Remove the issue item
	ip2.getController().getIssueAgenda().removeItem(item);
	// Add the activity
	ip2.frame.getSendPanel().initActivity(activity);
	ip2.frame.getSendPanel().initToMe();
    }
    */

}

// Issues:
// * Need a better approach than passing ip2 as a parameter to the
//   constructor and directly referring to ip2.controller.
