/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jan 16 01:50:16 2004 by Jeff Dalton
 * Copyright: (c) 2003 - 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.ispace.*;
import ix.util.lisp.*;

public class SetCapabilitiesHandler extends ActivityHandler {

    Symbol S_SET_CAPABILITIES = Symbol.intern("set-capabilities");

    IXAgent agent;
	
    public SetCapabilitiesHandler(IXAgent agent) {
	super("Set agent capabilities");
	this.agent = agent;
    }
	
    public List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((set-capabilities ?agent-name (?verb ...)))");
    }
	
    public boolean appliesTo(AgendaItem item) {
	LList pattern = item.getPattern();
	return pattern.length() == 3
	    && pattern.get(0) == S_SET_CAPABILITIES;
    }

    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }
	
    public void handle(AgendaItem item) {
	// (set-capabilities ?agentName ?verbs)
	LList pattern = (LList)Variable.removeVars(item.getPattern());
	String name = pattern.get(1).toString();
	List verbs = (List)pattern.get(2);
	List capabilities = makeVerbCapabilities(verbs);
	ContactManager contactManager = agent.getContactManager();
	contactManager.noteAgent(name);
	contactManager.setCapabilities(name, capabilities);
	item.setStatus(Status.COMPLETE);	    			  
    }
	
    List makeVerbCapabilities(List verbs) {
	List result = new LinkedList();
	for (Iterator i = verbs.iterator(); i.hasNext();) {
	    Object verb = i.next();
	    if (!(verb instanceof String || verb instanceof Symbol))
		throw new IllegalArgumentException
		    ("Invalid verb " + verb);
	    result.add(VerbCapability.from(verb.toString()));
	}
	return result;
    }

}

