/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 19 01:52:58 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.ip2;

import javax.swing.*;
import java.util.*;

import ix.ip2.event.*;
import ix.icore.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.util.xml.XML;		// for debugging output

/**
 * Generates HandlerActions that send a report.
 */
public class SendReportHandler extends ActivityHandler {

    protected Symbol
	Q_AGENT_NAME = Symbol.intern("?agent-name"),
	Q_TEXT = Symbol.intern("?text");

    public SendReportHandler() {
	super("Send report");
    }

    public List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((send-report ?agent-name &rest ?text))");
    }

    public boolean appliesTo(AgendaItem item) {
	return matchSyntax(item.getPattern()) != null;
    }

    public MatchEnv matchSyntax(LList pattern) {
	Debug.expect(getSyntaxList().size() == 1);
	return SimpleMatcher.match(getSyntaxList().get(0), pattern);
    }

    public void addHandlerActions(AgendaItem item) {
	item.addAction(new HandlerAction.AutomaticWhenBound(item, this));
    }

    public void handle(AgendaItem item) {

	MatchEnv env = matchSyntax(item.getPattern());
	String agentName = env.get(Q_AGENT_NAME).toString();
	LList textElements = (LList)env.get(Q_TEXT);
	String text = PatternParser.unparse(textElements);

	// Construct the report.
	Report report = new Report(ReportType.INFORMATION, text);
	report.setSenderId(Name.valueOf(IXAgent.getAgent().getAgentIPCName()));

	// Send the report.
	IPC.sendObject(agentName, report);

	item.setStatus(Status.COMPLETE);

    }

}
