/* Author: Jeff Dalton
 * Updated: Wed Sep 24 16:27:14 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.TableModelEvent;

import java.awt.BorderLayout;
import java.awt.event.*;

import java.util.*;

import ix.iface.util.CatchingActionListener;
import ix.iface.util.ToolFrame;
import ix.util.*;
import ix.util.lisp.*;

public class PropertyViewTable extends StateViewTable.ViewTable {

    ViewFrame frame;

    Object viewedObject = null;

    public PropertyViewTable(StateViewTable stateViewer) {
	super(stateViewer, "Property", "Value");
	frame = new ViewFrame();
	setKeySortComparator(new LexicographicComparator());
    }

    public void viewObject(Object target) {
	String pname = Lisp.printToString(target);
	Debug.noteln("Asked to see properties of", pname);
		     
	reset();
	viewedObject = target;
	recordNewValues(getStateViewerMap());
	// /\/: Call frame.viewObject(...) instead?
	frame.scroll.setBorder
		(BorderFactory.createTitledBorder
		 ("Properties of " + pname));

	frame.setVisible(true);
    }

    private Map getStateViewerMap() {
	return stateViewer.viewTable.getViewedMap();
    }

    public void reset() {
	super.reset();
	viewedObject = null;
    }

    void closeFrame() {
	Debug.noteln("Close on", this);
	frame.setVisible(false);
	reset();
    }

    protected String keyToString(Object key) {
	// We redefine this to omit the outermost open and close parans
	// and to replace the object with ~.
	final Symbol tilde = Symbol.intern("~");
	LList pattern = (LList)Collect.map((LList)key, new Function1() {
	    public Object funcall(Object elt) {
		return elt.equals(viewedObject) ? tilde : elt;
	    }
	});
	return Lisp.elementsToString(pattern);
    }

    public void recordNewValue(Object key, Object value) {
	// Accept a key and value only if the viewed object is in the key.
	if (getRowObjects(key, Lisp.NIL).contains(viewedObject))
	    super.recordNewValue(key, value);
    }

    protected boolean isObjectName(Object name) {
	// /\/: Make sure we count all objects in the state viewer
	// as objects, not only the ones we're showing here.
	return stateViewer.viewTable.isObjectName(name);
    }

    public void deleteEntry(Object key, Object value) {
	// /\/: We know this one is called, not deleteEntry(Object key).
	if (keyList.contains(key))
	    super.deleteEntry(key, value);
    }

    class ViewFrame extends ToolFrame {
	// Default is BorderLayout.

	Container contentPane = getContentPane();
	JScrollPane scroll;

	ViewFrame() {
	    super(stateViewer.ip2.getAgentDisplayName() +
		  " Object Properties");

	    // Make sure we control a WM "close"
	    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
	    addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    Debug.noteln("Property view windowClosing event");
		    closeFrame();
		}
	    });

	    JTable tab = getJTable();
	    /* JScrollPane */ scroll = new JScrollPane(tab);
	    scroll.setBorder
		(BorderFactory.createTitledBorder("Properties"));
	    contentPane.add(scroll, BorderLayout.CENTER);
	    contentPane.add(makeButtonPanel(), BorderLayout.SOUTH);
	    pack();
	    // /\/
	    Dimension size = getSize();
	    setSize(new Dimension((int)Math.round(size.getWidth()),
				  150));
	}

	protected JPanel makeButtonPanel() {
	    JPanel panel = new JPanel();
	    // Stick with default flowlayout for now.
	    JButton cancelButton = new JButton("Cancel");
	    ActionListener cancelListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    closeFrame();
		}
	    };
	    cancelButton.addActionListener
		(CatchingActionListener.listener(cancelListener));
	    panel.add(cancelButton);
	    return panel;
	}

    }

}

