/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Aug 23 19:00:25 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.iscript.IScriptSource;

import ix.util.*;
import ix.util.lisp.*;

public class LispComputeInterpreter extends LispInterpreter
       implements ComputeInterpreter {

    public static final Symbol UNDEF = Symbol.intern(":undef");

    protected Ip2ModelManager modelManager;

    public LispComputeInterpreter(Ip2ModelManager modelManager) {
	this.modelManager = modelManager;
    }

    public Object compute(Object form) {
	if (form instanceof Cons) {
	    Cons call = (Cons)form;
	    Object fn_form = call.car();
	    Object fn = topLevelEval(fn_form);
	    if (!(fn instanceof Function))
		throw new ClassCastException
		    ("The value of " + fn_form + " was not a function.");
	    LList args = call.cdr();
	    return topLevelApply((Function)fn, args.toArray());
	}
	else
	    throw new SyntaxError ("Illegal compute expression: " + form);
    }

    public void loadSupportCode(Object code) {
	if (code == null)
	    return;
//  	else if (code instanceof List) {
//  	    Debug.noteln("Loading compute support code", code);
//  	    for (Iterator i = ((LList)code).iterator(); i.hasNext();) {
//  		topLevelEval(i.next());
//  	    }
//  	}
	else if (code instanceof IScriptSource) {
	    IScriptSource source = (IScriptSource)code;
	    Debug.noteln("Loading " + source.getSyntax() + " source.");
	    topLevelEval(source.parseSource());
	}
	else if (code instanceof String) {
	    Debug.noteln("Loading support code from", code);
	    loadLisp((String)code);
	}
	else
	    throw new Error("Invalid support code", code);
    }

    protected Object getWorldStateValue(LList pattern) {
	return modelManager.getWorldStateValue(pattern);
    }

    protected void defineBuiltins() {

	super.defineBuiltins();

	define(new JFunction("get-world-state-value", 1) {
	    public Object applyTo(Object[] args) {
		LList pattern = (LList)mustBe(LList.class, args[0]);
		Object value = getWorldStateValue(pattern);
		return value == null ? UNDEF : value;
	    }
	});

    }

}



