/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Oct 17 20:00:36 2004 by Jeff Dalton
 * Copyright: (c) 2001 - 2002, 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

import javax.swing.*;
import java.awt.event.*;
import java.util.*;

import ix.ip2.event.*;
import ix.icore.*;
import ix.util.*;

/**
 * A simple editor for entering and viewing Issues.
 */
class IssueEditor extends ItemEditor {

    IssueEditor(AgendaViewer agendaViewer, String title) {
	super(agendaViewer, title);
	itemType = "Issue";
    }

    protected EditPanel makeEditPanel() {
	return new IssueEditPanel();
    }

    /**
     * Action interpreter
     */
    public void actionPerformed(ActionEvent e) {
	String command = e.getActionCommand();
	Debug.noteln("IssueEditor action:", command);
	if (handleViewCommand(e)) {
	    // Already handled
	}
	else if (command.equals("Close")) {
	    frame.setVisible(false);
	}
	else
	    Debug.noteln("Nothing to do for", command);
    }

    class IssueEditPanel extends EditPanel {

	IssueEditPanel() {
	    super();
	    modifyButton = makeButton("Modify Issue");
	    setUp();
	}

	protected void setUp() {

	    setBorder(BorderFactory.createTitledBorder("Issue"));

	    add(makeLeftLabel("Issue Pattern Text"));
	    add(new JScrollPane(itemText));

	    add(makeLeftLabel("Annotations"));
	    add(new JScrollPane(commentText));

	    newItemButtons.add(makeButton("Add Issue"));
	    newItemButtons.add(makeButton("Clear"));
	    newItemButtons.add(makeButton("Cancel"));

	    editItemButtons.add(modifyButton);
	    editItemButtons.add(makeButton("Copy Issue"));
	    editItemButtons.add(makeButton("Clear"));
	    editItemButtons.add(makeButton("Cancel"));

	    add(newItemButtons);
	}

	/**
	 * Action interpreter
	 */
	public void actionPerformed(ActionEvent e) {
	    String command = e.getActionCommand();
	    Debug.noteln("Issue action:", command);
	    if (command.equals("Add Issue")) {
		addItem();
	    }
	    else if (command.equals("Modify Issue")) {
		modifyItem();
	    }
	    else if (command.equals("Copy Issue")) {
		copyItem();
	    }
	    else if (command.equals("Clear")) {
		showNewItem();
	    }
	    else if (command.equals("Cancel")) {
		// Equiv to close + clear.
		frame.setVisible(false);
		showNewItem();
	    }
	    else
		throw new UnsupportedOperationException
		    ("Nothing to do for " + command);
	}

    }

}

