/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Aug 28 16:17:25 2006 by Jeff Dalton
 * Copyright: (c) 2002 - 2003, 2006, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import java.applet.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import javax.swing.*;

import ix.icore.IXAgent;
import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.applet.AppletCommunicationStrategy;
import ix.iface.util.ToolFrame;
import ix.iface.util.XColors;
import ix.iface.util.IFUtil;
import ix.util.*;
import ix.util.xml.XML;

/**
 * An I-P2 applet
 */
public class Ip2Applet extends Applet {

    public static final String INITIAL_SYMBOL_NAME = " I-P2 Applet ";

    AppletIp2 ip2;

    public void init() {

	Debug.noteln("Applet init() called");

	Debug.noteThreads = true;
	Debug.noteln("Running in deamon thead", 
		     Thread.currentThread().isDaemon());

	// It's not clear what we ought to do if there's already an
	// IXAgent visible to us.  With Mozilla, at least, that can
	// happen if the user goes back from the applet page and
	// then forward again -- if we don't do thisAgent = null.
	// Going back calls stop() and destroy(); going forward again
	// calls init() on a new (it seems) instance of Ip2Applet.
	{
	    IXAgent a = IXAgent.getAgent();
	    if (a != null) {
		Debug.noteln("An I-X agent already exists");
		// /\/: Assume it's an applet.
		// /\/: We're probably? a new instance of Ip2Applet.
		setBackground(XColors.LightSeaGreen);
		ip2 = (AppletIp2)a;
		ip2.restart(this);
		return;
	    }
	}

	Parameters.setIsApplet(true);

	Parameters.setParameter
	    ("ipc", "ix.applet.AppletCommunicationStrategy");

	// /\/: Otherwise, we get a security problem when it
	// tries to look at System.getProperty("user.name").
	Parameters.setParameter("symbol-name", INITIAL_SYMBOL_NAME);

	// /\/: With Xerces, we keep seeing things like this in the
	// httpd error log: ... File does not exist: 
        // .../applet-test/META-INF/services/org.apache.xerces.
	// xni.parser.XMLParserConfiguration
	// XML.SAXDriverClass = "gnu.xml.aelfred2.SAXDriver";

        setBackground(Color.white);

	ip2 = new AppletIp2();
	ip2.mainStartup(new String[]{});

    }

    public void start() {
	Debug.noteln("Applet start() called");
	ip2.start();
    }

    public void stop() {
	Debug.noteln("Applet stop() called");
	ip2.stop();
    }

    public void destroy() {
	Debug.noteln("Applet destroy() called");
	ip2.destroy();
    }

    public class AppletIp2 extends Ip2 {

	Plan savedPlan = null;
	Domain savedDomain = null;

	AppletCommunicationStrategy commStrategy = null;

	AppletIp2() {
	    super();
	}

	public Applet getApplet() {
	    return Ip2Applet.this;
	}

	protected Ip2Frame makeIp2Frame() {
	    return new AppletIp2Frame(this);
	}

	protected void startServer(Object agentName, String strategyName) {
	    Debug.noteln("AppletIp2 startServer method called");
	    super.startServer(agentName, strategyName);
	    commStrategy = (AppletCommunicationStrategy)
		             IPC.getCommunicationStrategy();
	}

	public void exit() {
	    //\/ Not entirely clear what we should do.
	    disposeFrames();
	    savedPlan = null;
	    savedDomain = null;
	    IXAgent.thisAgent = null;
	}

	public void start() {
	    commStrategy.appletStart();
	}

	public void stop() {
	    commStrategy.appletStop();
	}

	public void destroy() {
	    //\/ Not entirely clear what we should do.
	    commStrategy.appletDestroy();
	    savedPlan = controller.getModelManager().getPlan();
	    savedDomain = new Domain();	 // lose listeners
	    savedDomain.takeFrom(domain);
	    reset();
	    disposeFrames();
	}

	void restart(Ip2Applet newApplet) {
	    // /\/: We start over with a new AppletIp2 but try to
	    // give it any saved plan or domain.  We also give it
	    // the old Ip2's contact mamager, which should work.
	    // /\/: The contact manager will be asked to process
	    // command-line args, and if we've made that work
	    // with applet parameters, it will add agent capabilities
	    // that are already there.

	    // Clear old Ip2.
	    IXAgent oldIp2 = thisAgent;
	    thisAgent = null;
	    Debug.noteln("oldIp2 == this =>", oldIp2 == this);

	    // Make a new Ip2 and record it in the new applet.
	    AppletIp2 newIp2 = newApplet.new AppletIp2();
	    newApplet.ip2 = newIp2;

	    // Changes that have to be done before mainStartup.
	    Parameters.setParameter("symbol-name",
				    oldIp2.getAgentSymbolName());
	    if (savedDomain != null)
		newIp2.domain = savedDomain;
	    newIp2.contactManager = oldIp2.getContactManager();

	    // Call mainStartup -- this will also create a new GUI.
	    newIp2.mainStartup(new String[]{});	    

	    // Changes that have to be done after mainStartup.
	    if (savedPlan != null)
		newIp2.loadPlan(savedPlan);

	}

	void disposeFrames() {
	    frame.dispose();
	    ToolFrame.walkToolFrames(new Proc() {
		public void call(Object a) {
		    ToolFrame f = (ToolFrame)a;
		    f.dispose();
		}
	    });
	}

    }

    static class AppletIp2Frame extends NewIp2Frame {

	public AppletIp2Frame(Ip2 ip2) {
	    super(ip2);
	}

	protected JMenuBar makeMenuBar() {
	    JMenuBar bar = super.makeMenuBar();
            JMenu helpMenu = IFUtil.getMenuBarMenu(bar, "Help", true);
	    helpMenu.add(makeMenuItem("Applet Help"), 1);
	    return bar;
	}

	public void actionPerformed(ActionEvent e) {
	    String command = e.getActionCommand();
	    Debug.noteln("I-P2 Applet action:", command);
	    if (command.equals("Applet Help")) {
		ensureHelpFrame("ip2-applet-help.html");
	    }
	    else {
		super.actionPerformed(e);
	    }
	}

    }

}
