/* Author: Jeff Dalton
 * Updated: Wed May 21 19:50:09 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.awt.Component;

import ix.icore.event.AnnotationListener;

public interface AnnotationViewer extends AnnotationListener {

    /**
     * Return the GUI component that should be placed in the agent's
     * main user-interface frame.  The frame is passed as a parameter
     * in case different objects must be returned for different frame
     * classes.
     */
    public Component getView(PanelFrame frame);

    /**
     * Ask the user to enter a new annotation.
     */
    public void getNewItemFromUser();

    /**
     * Sets the viewer back to its initial state (or a reasonable
     * approximation).
     */
    public void reset();

}
