/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Apr 28 20:18:57 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.ip2;

import ix.icore.domain.Refinement;
import ix.util.lisp.LList;

// Must also be an instance of a subclass of java.awt.Component
// so that it can be added to a JPanel.  /\/

public interface AgendaViewer {

    // From the agent (Ip2)

    public void reset();

    // From the PanelController

    // /\/: Also in the AgendaListener interface
    public void setAgendaManager(AgendaManager m);

    // As an AgendaListener

    // public void itemAdded(AgendaItem i);

    // From the frame menu bar

    public void getNewItemFromUser();

    // From the ItemEditor

    public AgendaItem makeItem(LList pattern);

    public void addItem(AgendaItem i);

    public void saveExpansion(Refinement data);

    public void expandItem(AgendaItem i, Refinement instructions);

}

// Issues:
// * Some of this should really be in an ItemEditorListener, or something
// like that.  (Listener isn't quite right, because there can be only one
// and it's supposed to carry out particular instructions such as
// saveIssueExpansion.)  /\/
// * Should this extend AgendaListener like StateViewer does with
// ProcessStatusListener?  Or should StateViewer change?
