/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Feb 21 02:17:16 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.process.PNode;

import ix.icore.domain.Constraint;
import ix.icore.domain.Refinement;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.context.*;

public class AdviceManager {

    public static final Symbol
	S_ADVICE = Symbol.intern("advice"),
	S_EXPANSION_REFINEMENT = Symbol.intern("expansion-refinement");

    protected ContextMap verbToRefinementNames = new ContextHashMap();

    public AdviceManager(Ip2ModelManager mm) {
    }

    public void reset() {
	verbToRefinementNames.clearCompletely();
    }

    public void addConstraint(PNode node, Constraint c) {
	if (c.getRelation() != S_EXPANSION_REFINEMENT) {
	    Debug.noteln("Can't handle " + c + " at " + node);
	    return;
	}
	Symbol verb = (Symbol)c.getParameter(0);
	List refinementNames = (List)c.getParameter(1);
	List already = (List)verbToRefinementNames.get(verb);
	if (already != null
	      && !Collect.equalAsSets(already, refinementNames))
	    throw new IllegalArgumentException
		("Conflicting expansion refinement advice for " + verb +
		 " -- " + already + " vs " + refinementNames);
	Debug.noteln("Advice:", c);
	verbToRefinementNames.put(verb, refinementNames);
    }

    public boolean isUsableRefinement(Refinement r) {
	// We can just check whether the refinement can be used
	// with its own pattern's verb, because it would have to
	// be the same verb as in any matching node-pattern anyway.
	// /\/: We don't quite want to require that the verb be a Symbol.
	Object verb = r.getPattern().get(0);
	List advice = (List)verbToRefinementNames.get(verb);
	if (advice == null) {
	    // No advice for the plain verb, so try it with arity.
	    // /\/: Probably should check arity advice 1st, as more specific.
	    int arity = r.getPattern().size() - 1;
	    Symbol verbWithArity = Symbol.intern(verb + "/" + arity);
	    advice = (List)verbToRefinementNames.get(verbWithArity);
	    if (advice == null)
		// Still no advice - so all refinements are usable.
		return true;
	}
	// There is some advice: a list of refinement names.
	// Note that Refinement names are officially strings,
	// but the advice will typically use symbols. /\/
	for (Iterator i = advice.iterator(); i.hasNext();) {
	    if (i.next().toString().equals(r.getName()))
		return true;
	}
	return false;
    }

}
