/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Oct  2 17:51:50 2006 by Jeff Dalton
 * Copyright: (c) 2001 - 2002, AIAI, University of Edinburgh
 */

package ix.ip2;

import ix.icore.*;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;

import ix.util.*;
import ix.util.lisp.*;

/**
 * An AgendaEntry to represents an activity.
 */
public class ActivityItem extends AgendaItem {

    public static Symbol EXPANSION_REFINEMENT_NAME =
	Symbol.intern("expansion-refinement-name");

    public ActivityItem(Activity activity) {
	super(activity);
    }

    public ActivityItem(ActivityItem parent, Activity activity) {
	super(parent, activity);
    }

    protected PNode makePNode(PNode parent, LList pattern) {
	return new ActivityItem((ActivityItem)parent, new Activity(pattern));
    }

    public void setRefinement(Refinement r) {
	super.setRefinement(r);
	if (r.getName() != null) {
	    Ip2ModelManager mm = (Ip2ModelManager)getModelManager();
	    if (mm != null)
		mm.saveUndoAction(new UndoSetRefinement());
	    getAbout().setAnnotation(EXPANSION_REFINEMENT_NAME, r.getName());
	}
    }

    public String getExpansionRefinementName() {
	return (String)getAbout().getAnnotation(EXPANSION_REFINEMENT_NAME);
    }

    class UndoSetRefinement extends AbstractUndoAction {
	UndoSetRefinement() {
	    super("set expansion refinement name");
	}
	public void undo() {
	    if (getExpansionRefinementName() != null)
		getAbout().removeAnnotation(EXPANSION_REFINEMENT_NAME);
	}
    }

}
