/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Nov 12 16:50:42 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.util.*;

/**
 * An explanation of why a {@link HandlerAction} is not ready to be used.
 *
 * @see HandlerAction#isReady()
 * @see HandlerAction#getUnreadyReason()
 */
public abstract class ActionUnreadyReason {

    protected HandlerAction action;

    /**
     * Creates an unready reason for the indicated action.
     */
    public ActionUnreadyReason(HandlerAction action) {
	this.action = action;
    }

    /**
     * Returns the handler-action given when this reason was created.
     * Naturally, that should be the action whose unready status
     * is being explained by this ActionUnreadyReason.
     */
    public HandlerAction getAction() {
	return action;
    }

    /**
     * Returns an explanation in natural language, suitable for
     * presenting to a user.  Successive elements of the returned
     * array are treated as successive lines of the explanation.
     */
    public abstract String[] getExplanation();

}
