/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Aug 31 01:22:01 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.JComboBox;

/**
 * Adds a layer to a JComboBox so that the selected values can be
 * different than the items in the drop-down list.  For instance,
 * they might be instances of a different class.  Presumably there
 * is a mapping in each direction between the selected values
 * and corresponding list items.
 */
public abstract class ValueComboBox extends JComboBox {

    public ValueComboBox() {
	super();
    }

    public abstract Object getSelectedValue();

    public abstract void setSelectedValue(Object v);

}
