/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Jun  3 02:50:07 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.TableModelEvent;

import java.awt.event.*;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;

/**
 * A KeyValueTable that lets the user change the key-sorting comparator.
 */
public abstract class SortingKVTable extends KeyValueTable {

    public SortingKVTable(String keyColName, String valColName) {
	this(null, keyColName, valColName);
    }

    public SortingKVTable(Map initialMap,
			  String keyColName,
			  String valColName) {
	super(initialMap, keyColName, valColName);
	JTableHeader th = table.getTableHeader(); 
        th.addMouseListener(new KeySortMouseListener());
    }

    protected class KeySortMouseListener extends MouseAdapter {
	KeySortPopupMenu popup = new KeySortPopupMenu();
	public KeySortMouseListener() { 
	}
	public void mousePressed(MouseEvent e) {
	    if (SwingUtilities.isRightMouseButton(e)) {
		TableColumnModel columnModel = table.getColumnModel();
                int viewCol = columnModel.getColumnIndexAtX(e.getX()); 
                int col = table.convertColumnIndexToModel(viewCol);
		Debug.noteln("Table right press in column", col);
		if (col == 0)
		    popup.show(e.getComponent(), e.getX(), e.getY());
	    }
	}
    }

    protected class KeySortPopupMenu extends JPopupMenu {
	public KeySortPopupMenu() {
	    super();
	    add(new SortMenu("Sort"));
	}
    }

    protected class SortMenu extends JMenu implements ActionListener {
	public SortMenu(String text) {
	    super(text);
	    add(makeMenuItem("Most Recent Last"));
	    add(makeMenuItem("Most Recent First"));
	    add(makeMenuItem("Lexicographically"));
	    add(makeMenuItem("By Object"));
	}
	protected JMenuItem makeMenuItem(String text) {
	    JMenuItem item = new JMenuItem(text);
	    item.addActionListener(CatchingActionListener.listener(this));
	    return item;
	}
	public void actionPerformed(ActionEvent e) {
	    String command = e.getActionCommand();
	    Debug.noteln("Sort menu command", command);
	    if (command.equals("Most Recent Last"))
		setKeySortComparator(new MostRecentLastComparator());
	    else if (command.equals("Most Recent First"))
		setKeySortComparator(new MostRecentFirstComparator());
	    else if (command.equals("Lexicographically"))
		setKeySortComparator(new LexicographicComparator());
	    else if (command.equals("By Object"))
		setKeySortComparator(new PatternObjectComparator());
	    else
		throw new ConsistencyException
		    ("Nothing to do for " + command);
	}
    }

}
