/* Author: Jeff Dalton
 * Updated: Mon Jul  7 12:58:30 2003 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.*;

import java.awt.Font;
import java.awt.Color;

import ix.util.Util;
import ix.util.Debug;

/**
 * A panel that contains the application name and some credits.
 * It is intended to be placed at the bottom of the application's
 * main interface Frame.
 */

public class LogoPanel extends JPanel {

    public LogoPanel(String applicationName) {
	this(applicationName, "I-X Process Panel");
    }

    public LogoPanel(String applicationName, String longName) {
	this(applicationName, 
	     longName, 
	     Util.resourceImageIcon("ip2-logo.gif"));
    }

    public LogoPanel(String applicationName,
		     String longName,
		     ImageIcon icon) {
	this(applicationName, 
	     longName, 
	     "Based on I-X Technology",
	     icon);
    }

    public LogoPanel(String symbolName, String line1, String line2,
		     ImageIcon icon) {
		     
	super();

	setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

	// Symbol name in larger than default font.
	JLabel name = new JLabel(symbolName);
	Font nameFont = name.getFont();
	name.setFont(nameFont.deriveFont(nameFont.getSize2D() + (float)3.0));
	add(name);

	// I-X credits in smaller than normal font.
	{
	    Box box = Box.createVerticalBox();
	    JLabel label1 = new JLabel(line1);
	    JLabel label2 = new JLabel(line2);
	    Font font = label1.getFont();
	    Font smallFont = font.deriveFont(font.getSize2D() - (float)2.0);
	    label1.setFont(smallFont);
	    label2.setFont(smallFont);
	    box.add(label1);
	    box.add(Box.createVerticalStrut(2));
	    box.add(label2);

	    add(Box.createHorizontalStrut(10));
	    add(box);
	}

	// Logo over at the right edge.
	add(Box.createHorizontalGlue());
	if (icon != null)
	    add(new JLabel(icon));
	else
	    Debug.noteln("Ignoring null icon for LogoPanel.");

	// It's createEmptyBorder(top, left, bottom, right)
	// setBorder(BorderFactory.createEmptyBorder(1, 4, 4, 4));

	// When making it white, need grey around the edge.
	setBorder(BorderFactory.createMatteBorder(1,4,4,4,getBackground()));
	setBackground(Color.white);

    }

}

// Issues:
// * In something like font.deriveFont(font.getSize2D() - (float)2.0),
//   the compiler says "Incompatible type for method. Explicit cast
//   needed to convert double to int." if I don't cast the 2.0 to float.
//
//   This is strange.  I call getSize2D() instead of getSize() because
//   getSize2D() returns a float - and I want a float because deriveFont
//   regards a float as a point size and an int as style.  So it's
//   not clear why it thinks I might want to convert to int.  Maybe
//   it assumes I want the deriveFont(int) method rather than the
//   deriveFont(float) one, given that a double is neither float nor int.
