/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Dec  2 04:14:26 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iface.util;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import java.util.*;

import ix.util.*;

public class ListSelectionDialog extends JDialog 
                                 implements ActionListener {

    JList list;

    public static Object[] showDialog(Component parent, 
				      String title,
				      Object[] data) {
	Frame frame = JOptionPane.getFrameForComponent(parent);
	ListSelectionDialog dialog =
	    new ListSelectionDialog(frame, title, data);
	dialog.show();
	return dialog.getSelectedValues();
    }

    public static void main(String[] argv) {
	while (true) {
	    Object[] selected = ListSelectionDialog.showDialog
		(null, "Pick one", argv);
	    System.out.println("Selected: " + Arrays.asList(selected));
	}
    }

    /**
     * Creates a modal dialog with the specified owner frame,
     * title, and list data.
     */
    public ListSelectionDialog(Frame owner, String title, Object[] data) {
	super(owner, title, true);
	JPanel contentPane = new JPanel();
	setContentPane(contentPane);
	contentPane.setLayout(new BorderLayout());
	contentPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	// The JList
	list = new JList(data);
	list.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	JScrollPane listScroll = new JScrollPane(list);
	listScroll.setBorder(BorderFactory.createTitledBorder(title));
	contentPane.add(listScroll, BorderLayout.CENTER);
	// The buttons
	JButton cancel = IFUtil.makeButton("Cancel", this);
	JButton ok = IFUtil.makeButton("OK", this);
	Box buttons = Box.createHorizontalBox();
	buttons.add(Box.createHorizontalGlue());
	buttons.add(ok);
	buttons.add(Box.createRigidArea(new Dimension(5, 0)));
	buttons.add(cancel);
	buttons.add(Box.createHorizontalGlue());
	contentPane.add(buttons, BorderLayout.SOUTH);
	pack();
    }

    public Object[] getSelectedValues() {
	return list.getSelectedValues();
    }

    public void actionPerformed(ActionEvent e) {
	String command = e.getActionCommand();
	Debug.noteln("ListSelectionDialog command", command);
	if (command.equals("OK")) {
	    dispose();
	}
	else if (command.equals("Cancel")) {
	    list.setSelectedIndices(new int[]{});
	    dispose();
	}
	else
	    throw new ConsistencyException
		("Don't know what to do for", command);
    }

}
