/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Mar 12 02:25:03 2006 by Jeff Dalton
 * Copyright: (c) 2005, 2006, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.*;

import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

import java.util.*;

import ix.util.*;

// Here is a more brute-force way to make the font change.
//
//   import javax.swing.text.MutableAttributeSet;
//   import javax.swing.text.SimpleAttributeSet;
//
//   MutableAttributeSet style = new SimpleAttributeSet();
//
//   // We need a font that's more readable than the default.
//   StyleConstants.setFontSize(style, 12);
//   StyleConstants.setFontFamily(style, "Dialog");
//
//   // /\/: This is a hack to change the font.
//   HTMLDocument doc = (HTMLDocument)getDocument();
//   doc.setCharacterAttributes(0, text.length(), style, false);

/**
 * An HTMLEditorKit customised for use in I-X applications.
 * At present, it just ensures that a nicer default font is used.
 */
public class IXHtmlEditorKit extends HTMLEditorKit {

    protected StyleSheet ixStyleSheet;

    public IXHtmlEditorKit() {
	// /\/: We want to change the font, because the default
	// is terrible.  I tried many ways of doing this in Java 1.4.2,
	// all nicer-looking, but this is the only one that worked.

	// There's a style-sheet shared by all the editor kits.
	// We don't want to change that one, so we create our
	// own "around" it.  /\/: Now we modify a copy.

	StyleSheet shared = super.getStyleSheet();
	ixStyleSheet = (StyleSheet)Util.cloneBySerializing(shared);
	Style s = ixStyleSheet.getStyle("body");
	int incr = Parameters.getInt("font-increment", 0);
	StyleConstants.setFontFamily(s, "Dialog");
	StyleConstants.setFontSize(s, 12 + incr);

	// /\/: We'd like to change the table border styles
	// to solid from outset for table and inset for th and td,
	// but only inset, outset, and none are supported.
	// See the javadoc for javax.swing.text.html.CSS.
    }

    public StyleSheet getStyleSheet() {
	return ixStyleSheet;
    }

    /**
     * Sets the font-family for the "body" element.
     */
    public void setStyleSheetFontFamily(String family) {
	Style s = ixStyleSheet.getStyle("body");
	StyleConstants.setFontFamily(s, family);
    }

}
