/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Dec  3 03:52:06 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iface.util;

import java.io.StringWriter;
import java.io.IOException;

import java.util.*;

import ix.util.*;

public class HtmlStringWriter extends HtmlWriter {

    StringWriter stringWriter;

    public HtmlStringWriter() {
	this(new StringWriter());
    }

    public HtmlStringWriter(int initialSize) {
	this(new StringWriter(initialSize));
    }

    public HtmlStringWriter(StringWriter w) {
	super(w);
	this.stringWriter = w;
    }

    public void close() {
	super.close();
	try {
	    stringWriter.close();
	}
	catch (IOException e) {
	    throw new RethrownException(e);
	}
    }

    public void flush() {
	super.flush();
	stringWriter.flush();
    }

    public StringBuffer getBuffer() {
	return stringWriter.getBuffer();
    }

    public String toString() {
	return stringWriter.toString();
    }

}
