/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Oct 11 03:41:34 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iface.plan;

import java.io.*;
import java.util.*;

import ix.icore.domain.*;
import ix.icore.plan.Plan;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Saves a Plan's state as an .init file.
 */
public class InitSaver {

    public InitSaver() { }

    public void savePlan(Plan plan, File file) throws IOException {
	if (plan.getWorldState() == null) {
	    Debug.warn("There is no state to save.");
	    return;
	}
	BufferedWriter out = new BufferedWriter(new FileWriter(file));
	for (Iterator i = plan.getWorldState().iterator(); i.hasNext();) {
	    PatternAssignment pv = (PatternAssignment)i.next();
	    out.write(PatternParser.unparse(pv.getPattern()));
	    out.write(" = ");
	    out.write(Lisp.printToString(pv.getValue()));
	    out.newLine();
	}
	out.close();
    }

}
