/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jan 26 16:11:10 2006 by Jeff Dalton
 * Copyright: (c) 2000, 2004, 2006, AIAI, University of Edinburgh
 */

package ix.iface.domain;

import ix.util.lisp.Symbol;

/**
 * Defines constants that are useful when processing "Lisp syntax"
 * domain definitions.
 *
 * @see LTF_Parser
 */

public interface LTF_Symbols {

    static final Symbol
	S_REFINEMENT   = Symbol.intern("refinement"),
	S_VARIABLES    = Symbol.intern("variables"),
	S_NODES        = Symbol.intern("nodes"),
	S_ORDERINGS    = Symbol.intern("orderings"),
	S_CONSTRAINTS  = Symbol.intern("constraints"),
	S_ISSUES       = Symbol.intern("issues"),
	S_ISSUE        = Symbol.intern("issue"),
	S_OBJECT_CLASS = Symbol.intern("object-class"),
	S_ANNOTATIONS  = Symbol.intern("annotations"),
        S_MAP          = Symbol.intern("Map"),
	S_SELF         = Symbol.intern("self"),
	S_INCLUDE      = Symbol.intern("include");

    static final Symbol
	Q_PATTERN     = Symbol.intern("?pattern"),
	Q_VALUE       = Symbol.intern("?value"),
	Q_MIN         = Symbol.intern("?min"),
	Q_MAX         = Symbol.intern("?max");

}
