/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb  4 23:09:29 2004 by Jeff Dalton
 * Copyright: (c) 2001 - 2004, AIAI, University of Edinburgh
 */

package ix.icore.process;

import java.util.*;

import ix.icore.Status;
import ix.icore.HasStatus;

import ix.util.*;

// From a node's point of view, things should normally look like this:
//
//  Node          Begin         End
//  BLANK         BLANK         BLANK
//  POSSIBLE      POSSIBLE      BLANK
//  EXECUTING     COMPLETE      BLANK or POSSIBLE
//  COMPLETE      COMPLETE      COMPLETE
//  IMPOSSIBLE    ?             IMPOSSIBLE?
//  NA            ?             NA?

public class StatusStepper {

    protected ProcessModelManager modelManager;

    public StatusStepper(ProcessModelManager pmm) {
	this.modelManager = pmm;
    }

    public void computeStatus(PNode node) {
    }

    public void changeStatus(PNode node, Status status) {
    }

    public static boolean allHaveStatus(List l, Status status) {
	Iterator i = l.iterator();
	while(i.hasNext()) {
	    HasStatus h = (HasStatus)i.next();
	    if (h.getStatus() != status)
		return false;
	}
	return true;
    }

}
