/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun May 11 15:46:18 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.icore.plan.build;

import ix.icore.*;
import ix.icore.domain.*;
import ix.icore.plan.*;

/**
 * Constructs a plan piece by piece.
 */
public interface PlanBuilder {

    /**
     * Adds a top-level issue to the plan.
     */
    public void addIssue(Issue issue);

    /**
     * Adds a subissue of the specified issue.
     */
    public void addSubissue(Issue issue, Issue subissue);

    /**
     * Adds a top-level activity to the plan.
     */
    public void addActivity(Activity activity);

    /**
     * Adds a subactivity of the specified activity.
     */
    public void addSubactivity(Activity activity, Activity subactivity);

    /**
     * Adds a top-level constraint to the plan.
     */
    public void addConstraint(Constraint c);

    /**
     * Sets a top-level annotation.
     */
    public void setAnnotation(Object key, Object value);

    /**
     * Builds everything added so far into a plan and returns that plan.
     */
    public Plan getPlan();

}
