/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue May  6 18:42:23 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;
import ix.util.*;

/**
 * Scope values for {@link PlanVariable}s.
 */
public final class VariableScope extends EnumeratedValue {

    private static List values = new LinkedList();

    private VariableScope() { }

    private VariableScope(String name) {
	this.name = name;
	recordValue(values, this);
    }	

    public static final VariableScope
	LOCAL  = new VariableScope("local"),
	GLOBAL = new VariableScope("global");

    public String toString() {
	return name;
    }

    public static List values() {
	return Collections.unmodifiableList(values);
    }

    public static VariableScope valueOf(String name) {
	return (VariableScope)getValueElseError(values, name);
    }

}
