/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Feb 17 18:44:21 2006 by Jeff Dalton
 * Copyright: (c) 2004, 2006, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import ix.icore.Activity;
import ix.util.lisp.Symbol;

public abstract class ProcessParameter implements java.io.Serializable {

    protected Symbol name;
    protected Symbol type;
    protected Symbol value;

    protected Activity activity; // normally null

    public ProcessParameter() {
        super();
    }

    public ProcessParameter(Symbol name, Symbol type, Symbol value) {
        this.name = name;
	this.type = type;
	this.value = value;
    }

    public boolean isInput() {
	return false;
    }

    public boolean isOutput() {
	return false;
    }

    public Symbol getName() {
        return name;
    }

    public void setName(Symbol name) {
        this.name = name;
    }

    public Symbol getType() {
        return type;
    }

    public void setType(Symbol type) {
        this.type = type;
    }

    public Symbol getValue() {
        return value;
    }

    public void setValue(Symbol value) {
        this.value = value;
    }

    public Activity getActivity() {
	return activity;
    }

    // N.B. There's no setActivity method, and so the usual
    // ClassSyntax will not include the activity field.

    // /\/: It's not clear whether we should attach the
    // Activity or the ActivityItem.  The ActivityItem
    // would be more generally useful, because we can easily
    // get from it to the Activity.

    /**
     * Returns a copy of this ProcessParameter with the activity
     * field filled-in.
     */
    public abstract ProcessParameter attachTo(Activity act);

}
