/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 16 22:56:33 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.*;
import ix.util.*;

/**
 * Describes one level of the expansion of a {@link PlanNode}.
 */
public class PlanRefinement extends AbstractRefinement {

    protected ListOfPlanVariableDeclaration planVariableDeclarations;
    protected ListOfPlanNode planNodes;
    protected ListOfConstrainer constraints;

    public PlanRefinement() {
    }

    public ListOfPlanVariableDeclaration getPlanVariableDeclarations() {
        return planVariableDeclarations;
    }

    public void setPlanVariableDeclarations
	           (ListOfPlanVariableDeclaration planVariableDeclarations) {
        this.planVariableDeclarations = planVariableDeclarations;
    }

    public ListOfPlanNode getPlanNodes() {
        return planNodes;
    }

    public List getSubitems() {
	return getPlanNodes();
    }

    public void setPlanNodes(ListOfPlanNode planNodes) {
        this.planNodes = planNodes;
    }

    public void setSubitems(List planNodes) {
	setPlanNodes(new LinkedListOfPlanNode(planNodes));
    }

    public ListOfConstrainer getConstraints() {
        return constraints;
    }

    public void setConstraints(ListOfConstrainer constraints) {
        this.constraints = constraints;
    }

    public List getOrderings() {
	return getConstraints(Ordering.class);
    }

    public List getConstraints(Class constraintClass) {
	List result = new LinkedList();
	for (Iterator i = Collect.iterator(constraints); i.hasNext();) {
	    Object constraint = i.next();
	    if (constraintClass.isInstance(constraint))
		result.add(constraint);
	}
	return result;
    }

}
